/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.lifecycle.Registries;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2C_AnimationPacket
extends AbstractNetworkPacket<S2C_AnimationPacket> {
    private Action action;
    private ResourceLocation typeId;

    public S2C_AnimationPacket() {
    }

    public S2C_AnimationPacket(Action action, ResourceLocation typeId) {
        this.action = action;
        this.typeId = typeId;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.action);
        buffer.func_192572_a(this.typeId);
    }

    @Override
    public S2C_AnimationPacket decode(PacketBuffer buffer) {
        return new S2C_AnimationPacket((Action)buffer.func_179257_a(Action.class), buffer.func_192575_l());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        this.handleGeneric(pipeline);
    }

    @OnlyIn(value=Dist.CLIENT)
    private <A extends IAnimation> void handleGeneric(IAnimationPipeline pipeline) {
        AnimationType<?> type = Registries.ANIMATION_TYPES.getElement(this.typeId);
        switch (this.action) {
            case PLAY: {
                pipeline.insert(type);
                break;
            }
            case STOP: {
                pipeline.remove(type);
            }
        }
    }

    public static enum Action {
        PLAY,
        STOP;

    }
}

